
//sValidation=nyfjs
//sCaption=Replicate from RTF to HTML ...
//sHint=Replicate current database with RTF notes converted into HTML for cross platform support
//sCategory=MainMenu.Maintain
//sLocaleID=p.ReplicateRTF2HTML
//sAppVerMin=6.3
//sShortcutKey=

var _lc=function(sTag, sDef){return plugin.getLocaleMsg(sTag, sDef);};
var _lc2=function(sTag, sDef){return _lc(plugin.getLocaleID()+'.'+sTag, sDef);};

try{

	var xNyf=new CNyfDb(-1);
	if(xNyf.isOpen()){

		plugin.initProgressRange(plugin.getScriptTitle());

		var sDstFn=platform.getSaveFileName(
			{ sTitle: ''
			, sFilter: 'myBase databases (*.nyf)|*.nyf|All files (*.*)|*.*'
			, sDefExt: '.nyf'
			, bOverwritePrompt: true
			});

		if(sDstFn){

			var sMsg=_lc2('SetPasswd1', 'Type a password for the new database; Or leave blank to skip;');
			var sPass1=prompt(sMsg, ''), sPass2='';
			if(sPass1){
				sMsg=_lc2('SetPasswd2', 'Type the password again to confirm;');
				sPass2=prompt(sMsg, '');
			}

			if(sPass1!=undefined && sPass2!=undefined){
				if(sPass1==sPass2){

					var xFn=new CLocalFile(sDstFn);
					if(xFn.createFile()){
						var nSsgVer=5, bUtf8=true, nZlib=9;
						var xDbDst=new CNyfDb(sDstFn, false, 0, nSsgVer, bUtf8);
						if(xDbDst.isOpen()){

							if(sPass1) xDbDst.setDbPassword(sPass1);
							if(nZlib>=0 && nZlib<=9) xDbDst.setCompressLevel(nZlib);

							var sDefNoteFn=plugin.getDefNoteFn();

							var sTmpDir='';
							{
								var xTmpDir=new CLocalFile(platform.getTempFolder()); xTmpDir.append('nyf_rtf2html');
								if(xTmpDir.exists()){
									sTmpDir=xTmpDir.toString();
								}else{
									if(xTmpDir.createDirectory()){
										sTmpDir=xTmpDir.toString();
									}
								}
							}

							var _copy_entry_attr=function(sSrc, sDst){
								if(!sDst) sDst=sSrc;
								xDbDst.setFolderHint(sDst, xNyf.getFolderHint(sSrc));
								xDbDst.setEntryAttr(sDst, xNyf.getEntryAttr(sSrc));
								xDbDst.setEntryAppAttr(sDst, xNyf.getEntryAppAttr(sSrc));

								var n=xNyf.getEntryAppDataCount(sSrc);
								for(var i=0; i<n; ++i){
									var x=xNyf.getAppDataOfEntryByPos(sSrc, i);
									xDbDst.setAppDataOfEntry(sDst, i, x);
								}

								xDbDst.setCreateTime(sDst, xNyf.getCreateTime(sSrc));
								xDbDst.setModifyTime(sDst, xNyf.getModifyTime(sSrc));
							};

							var c_sInfoFooter=plugin.isAppLicensed() ? '' : 'Generated with <a href="http://www.wjjsoft.com/mybase">myBase Desktop</a> by <a href="http://www.wjjsoft.com/">Wjj Software</a>';
							var c_sCssFooter='font-size: small; font-style: italic; text-align: right; margin-top: 4em; padding-top: 4px; border-top: 2px solid gray;';
							var c_sCssGlobal='\r\ntable{border: 1px solid gray;}'
								+ '\r\ntd{border: 1px dotted gray;}'
								+ '\r\np{margin: 3px 0 3px 0; padding: 0;}'
								+ '\r\n#ID_Footer{'+c_sCssFooter+'}'
								+ '\r\n'
								;

							var nInfoItems=0, vFailed=[];
							var sUtf8Tag='__encoding.utf8';
							var xUtf8Tag=new CLocalFile(plugin.getDefRootContainer()); xUtf8Tag.append(sUtf8Tag);

							var _act_on_treeitem=function(sSsgPath, iLevel){

								if(xNyf.folderExists(sSsgPath, false)){

									var sTitle=xNyf.getFolderHint(sSsgPath); if(!sTitle) sTitle='New info item';

									var bContinue=plugin.ctrlProgressBar('#'+nInfoItems+sTitle, 1, true);
									if(!bContinue) return true;

									if(xDbDst.createFolder(sSsgPath)){
										_copy_entry_attr(sSsgPath);
										var vFiles=xNyf.listFiles(sSsgPath);
										for(var i in vFiles){
											var sName=vFiles[i];

											var bDefNoteFn=(sName==sDefNoteFn);

											var sMsg=sName; if(bDefNoteFn) sMsg=sTitle;

											var bContinue=plugin.ctrlProgressBar(sMsg, 1, true);
											if(!bContinue) return true;

											var xSsgFn=new CLocalFile(sSsgPath); xSsgFn.append(sName);

											//2013.10.15 the UTF8 tag is already inserted while the new db was created.
											if(sName==sUtf8Tag && xSsgFn.toString()==xUtf8Tag.toString()){
												continue;
											}

											var xHtmFn=new CLocalFile(sSsgPath); xHtmFn.append(sDefNoteFn);
											xHtmFn.changeExtension('.html');
											if(bDefNoteFn && !xDbDst.fileExists(xHtmFn)){ //2014.4.25 skip rtf2html conversion if it's existing;
												var sRtf=xNyf.loadText(xSsgFn);
												sHtml=platform.convertRtfToHtml(sRtf
													, {bInner: false
														, bPicture: true
														, sImgDir: sTmpDir
														, sCharset: 'UTF-8'
														, sTitle: sTitle
														, sFooter: '' //c_sInfoFooter
														, sStyle: c_sCssGlobal
														, sJsFiles: ''
													}
												);
												if(sHtml){
													if(xDbDst.createTextFile(xHtmFn, sHtml)>=0){
														_copy_entry_attr(xHtmFn, xSsgFn); //copy attr from original RTF file;
														var vBmp=new CLocalFile(sTmpDir).listFiles();
														for(var i in vBmp){
															var sExt=new CLocalFile(vBmp[i]).getExtension(true);
															if(sExt=='.bmp' || sExt=='.jpg'){
																var xDst=new CLocalFile(sSsgPath); xDst.append(vBmp[i]);
																var xSrc=new CLocalFile(sTmpDir); xSrc.append(vBmp[i]);
																if(xDbDst.createFile(xDst, xSrc)>=0){
																	_copy_entry_attr(xDst, xSsgFn); //copy attr from original RTF file;
																}else{
																	vFailed.push(xDst);
																}
																xSrc.delete();
															}
														}
													}else{
														vFailed.push(xSsgFn);
													}
												}
											}else{
												var sTmpFn=platform.getTempFile(); platform.deferDeleteFile(sTmpFn);
												var xTmpFn=new CLocalFile(sTmpFn);
												if(xNyf.exportFile(xSsgFn, sTmpFn)>=0){
													if(xDbDst.createFile(xSsgFn, sTmpFn)>=0){
														//ok;
													}
												}
												xTmpFn.delete();
												_copy_entry_attr(xSsgFn);
											}
										}
									}
									nInfoItems++;
									if(xDbDst.getSsgVer()==5){
										if(nInfoItems % 400 == 0){
											plugin.ctrlProgressBar('committing ...', 1, false);
											xDbDst.save();
										}
									}
								}
							};

							xNyf.traverseOutline('/', false, _act_on_treeitem);

							plugin.ctrlProgressBar('Finishing ...', 1, false);
							if(xDbDst.save()){
								if(vFailed.length>0){
									var sMsg='';
									for(var i in vFailed){
										if(!sMsg) sMsg+='\n';
										sMsg+=vFailed[i];
									}
									alert(_lc2('Problems', 'The database has been generated with some problems converting the following files;')+'\n\n'+sMsg);
								}else{
									alert(_lc2('Done', 'Successfully replicated the database.')+'\n\n'+sDstFn);
								}
							}

							//Finally we need to remove the temporary folder precedingly created;
							if(sTmpDir){
								var xTmpDir=new CLocalFile(sTmpDir);
								if(xTmpDir.exists()){
									if(!xTmpDir.delete()){
										alert('Failed to remove the Temporary folder. You may need to manually clear it.'+'\n\n'+xTmpDir);
									}
								}
							}

						}else{
							alert('Failed to create the new database.'+'\n\n'+sDstFn);
						}
					}else{
						alert('Failed to create the new file.'+'\n\n'+sDstFn);
					}

				}else{
					alert(_lc2('PasswdErr', 'The passwords do not match excatly.'));
				}
			}
		}

	}else{
		alert(_lc('Prompt.Warn.NoDbOpened', 'No database is currently opened.'));
	}

}catch(e){
	alert(e);
}
